<?php
/**
 * @brief		Dedicated Server Package
 * @author		<a href='https://www.invisioncommunity.com'>Invision Power Services, Inc.</a>
 * @copyright	(c) Invision Power Services, Inc.
 * @license		https://www.invisioncommunity.com/legal/standards/
 * @package		Invision Community
 * @subpackage	Nexus
 * @since		29 Apr 2014
 */

namespace IPS\nexus\Package;

/* To prevent PHP errors (extending class does not exist) revealing path */
if ( !\defined( '\IPS\SUITE_UNIQUE_KEY' ) )
{
	header( ( isset( $_SERVER['SERVER_PROTOCOL'] ) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0' ) . ' 403 Forbidden' );
	exit;
}

/**
 * Dedicated Server Package
 */
class _Dedi extends \IPS\nexus\Package
{
	/**
	 * @brief	Icon
	 */
	public static $icon = 'database';
	
	/**
	 * @brief	Title
	 */
	public static $title = 'dedicated_server';
	
	/**
	 * Show Purchase Record?
	 *
	 * @return	bool
	 */
	public function showPurchaseRecord()
	{
		return TRUE;
	}
	
	/**
	 * On Purchase Generated
	 *
	 * @param	\IPS\nexus\Purchase	$purchase	The purchase
	 * @param	\IPS\nexus\Invoice	$invoice	The invoice
	 * @return	void
	 */
	public function onPurchaseGenerated( \IPS\nexus\Purchase $purchase, \IPS\nexus\Invoice $invoice )
	{	
		try
		{
			$server = \IPS\nexus\Hosting\Server::load( $purchase->name, 'server_hostname' );
			$server->dedicated = $purchase->id;
			$server->save();		
		}
		catch ( \OutOfRangeException $e ) { }
		
		return parent::onPurchaseGenerated( $purchase, $invoice );
	}
	
	/**
	 * On Purchase Canceled
	 *
	 * @param	\IPS\nexus\Purchase	$purchase	The purchase
	 * @return	void
	 */
	public function onCancel( \IPS\nexus\Purchase $purchase )
	{
		try
		{
			$server = \IPS\nexus\Hosting\Server::load( $purchase->id, 'server_dedicated' );
			$server->dedicated = 0;
			$server->save();		
		}
		catch ( \OutOfRangeException $e ) { }
		
		return parent::onCancel( $purchase );
	}
}